function map = fir2(varargin)
%An attempt to create my own colormap.  The design is based off the fire
%colormap in imageJ.
%Synatax:  map = fir2(depth);
%Input: depth = The color depth of the map, e.g., 256 colors, 64 colors...
%       Note: 8bit = 256, 16bit = 65536, 32bit = 4,294,967,296
%Output: map = a 3xdepth array, where column 1 = red, 2 = green, 3 = blue.

if isempty(varargin)           %Set default for color depth if necessary
    depth = 256;
else
    depth = varargin{1,1};
end

map = zeros(depth,3);

for i = 1:depth
    if i<round(depth*0.2617)
        map(i,1) = (3*i-((depth/16)*3))/depth;      %Set the red channel
    else
        map(i,1) = (1.4*i+((3*round(depth*0.2617))-((depth/16)*3)-(1.4*round(depth*0.2617))))/depth;
    end
    
    if i<round(depth*0.5273)
        map(i,2) = (2.5*i-((depth/8)*3)*2.5)/depth;  %Set the green channel
    else
        map(i,2) = (1.8*i+((2.5*round(depth*0.5273))-(((depth/8)*3)*2.5)-(1.8*round(depth*0.5273))))/depth;
    end
    
    if i<depth/2                            %Set the blue channel
        map(i,3) = (round((depth*sin((i/(depth/7.1))-0.15))*0.88)/depth);
    else
        map(i,3) = (floor((depth*sin(i/(depth/7.5294)))*1.17)/depth);
    end
    
    for j = 1:3
        if map(i,j)<0                          %Colors definitions must be between 0 and depth or 1
            map(i,j) = 0;
        end
        if map(i,j)>1
            map(i,j) = 1;
        end
    end
end